# 第六章 开源组织及开源生态发展现状

开源生态是指由开源组织和整个产业界互动形成的、广泛联系的合作平台。中国开源正从早期的使用者、跟随者、参与者，逐渐变成影响者、创作者和贡献者，开始涌现出越来越多的开源开发者、开源项目、开源组织和开源企业，开源生态逐渐完善。中国作为开源生态发展最具活力和潜力的国家之一，开源组织的数量和质量不断提升，开源软件的使用者和贡献者数量持续增长，国家支持开源发展的政策力度不断加大，中国的开源产业链也在不断完善。越来越多的企业意识到开源技术的重要性，积极参与到开源社区中，贡献代码、资源和经验，推动开源生态的发展。中国开源生态的蓬勃发展，不仅对于中国的技术创新和产业发展具有重要意义，对于全球的开源生态同样产生了积极的影响。

## 6.1 发展现状

开源组织是开源生态中的重要组成部分，包含开源基金会、综合型产业联盟、专业型开源组织、地区型开源组织、开源推广型社会组织等几大类型。

从全球范围来看，知名的开源组织都具备透明公开、自组织化、社区驱动、开放合作、社会价值等共性特点，同时具有各自的鲜明特征。例如发起了“自由软件运动”的自由软件基金会（FSF）、定义了何为“开源”的OSI组织、维护Linux内核生态的Linux基金会、孕育了Kubernetes等明星项目的云原生领域的CNCF基金会、孵化了Apache应用服务器的Apache软件基金会等。这些成功的基金会和开源组织，几乎毫无例外地都搭建起开放、中立的舞台，让社区领袖带领开发者，通过经年累月的努力与奋斗，掀起技术的浪潮与变革。

随着中国开源软件的快速发展，国内涌现出越来越多的开源组织，积极地为完善中国开源生态做出贡献。例如在国际上颇具影响力的中国开源软件推进联盟（COPU），倡导发展开源芯片的中国开放指令生态（RISC-V）联盟和中国RISC-V产业联盟，关注开源人工智能等的新一代人工智能产业技术创新战略联盟，聚焦工业4.0的开源工业互联网联盟，着力于云计算产业的中国开源云联盟、云计算开源产业联盟等，都彰显了中国开源生态蓬勃发展的生命力。当前在国内也涌现出一批开源推广型社区组织，如开源社、开源中国社区以及ALC（Apache Local Community）北京/深圳等，这些以开源爱好者和志愿者为主体的推广组织，对推动国内的开源知识普及、开源文化推广有巨大的积极意义。国内开源组织的发展，经历了借鉴、发展、创新的全历程，下面是我国的一些重点开源组织。

### 6.1.1 开源基金会

开源基金会是开源组织的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的商标权，以及与代码相关知识产权的授权，与商业公司没有任何商业利益冲突，这为贡献者、开发者以及用户提供了良好的协作平台。基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库（一般基于第三方平台）、问题跟踪技术指导、法律支持、项目投资、公共关系维护等，部分基金会还会提供一些公共的平台能力，以辅助项目日常的运营和治理，并满足项目在不同生命周期阶段对于开放治理的需求。目前国际上已有几十家专业的开源基金会在全球的开源生态中发挥着巨大作用，如1985年建立的自由软件基金会（FSF）、1999年创建的Apache软件基金会、2000年成立的Linux基金会以及2004年成立的Eclipse基金会等。

#### 开放原子开源基金会

2020年6月12日我国首家开源基金会——开放原子开源基金会经国务院批准，在民政部正式登记注册，业务主管单位是工业和信息化部。开放原子开源基金会第一批成员包括华为、阿里、腾讯、百度、360、浪潮、招商银行等十余家骨干企业，作为国内首家致力于开源产业公益事业的非营利性独立法人机构，开放原子开源基金会遵循开源发展理念，秉持“繁荣开源事业、共享开源价值”的愿景，遵循“以开发者为本的开源项目孵化平台、科技公益性服务机构”的定位，以打造科技创新共同体、孵化明星开源项目、构筑技术竞争优势、培育新兴产业生态、助力新一代信息技术和产业发展为目标，发挥开源项目的孵化器、连接器、倍增器的作用，达成提升我国对全球的开源贡献的使命。

开放原子开源基金会专注于开源软件的推广传播、法务协助、资金支持、技术支撑及开放治理等公益性事业；促进、保护、推广开源软件的发展与应用；以开放、共享、共建、共治为原则，坚持开源项目自治，致力于推进开源生态繁荣和可持续发展。自成立以来，开放原子开源基金会构建了开放共享、共建共治的开源服务机制，在募集资金、项目孵化、生态拓展、国际合作、开源法务与知识产权等方面取得积极进展。开放原子开源基金会的成立是一次创新实践，也是中国开源生态建设的重要里程碑。

开放原子开源基金会现有捐赠单位共47家（部分企业要求不露出），其中白金捐赠人16家，黄金捐赠人13家，白银捐赠人18家，与本基金会达成战略合作的开源贡献人6家。

![白金捐赠人](https://img-blog.csdnimg.cn/f6da3d5abd2645aebbe4fde80e9c44c7.png#pic_center)

![黄金捐赠人](https://img-blog.csdnimg.cn/730c318aaf574a82b76facec1b749509.png#pic_center)

![白银捐赠人](https://img-blog.csdnimg.cn/54fb5b8d93764acca7a2a1350e63fefb.png#pic_center)

![开源贡献人](https://img-blog.csdnimg.cn/c3a61bb2811a4ff289b4f7cc139da2a0.png#pic_center)

开放原子开源基金会通过明星项目牵引，大中小协同发展模式，推动开源项目运营治理。当前有30个开源项目通过技术监督委员会（TOC）的技术准入，其中有10个项目正式进入孵化流程，包括OpenHarmony、openEuler、XuperCore（待更名）、Pika（待更名）、TencentOS Tiny（待更名）、AliOS Things（待更名）、hapjs、OpenBlock（待更名）、铜锁/Tongsuo、开源大师兄（待更名），覆盖操作系统、云原生、数据库、区块链、物联网、密码学、低代码等重点领域。其中OpenHarmony、openEuler两个重点开源项目在业界形成较大影响力，累计数亿人次、数百万用户企业通过网络免费获取、使用项目的公开源代码并协同开发，节约了大量研发成本和社会交易成本。

OpenHarmony开源项目已发布OpenHarmony 3.2版本，支持手机、平板、大屏等复杂带屏设备应用开发。项目代码仓库超过400个，代码行数超过1亿行，下载量突破1.3亿，已有5100+位代码贡献者，活跃度指数在我国最大代码托管平台上位列第一，累计已有90个厂家的242款产品基于代码进行创新并通过兼容性测评。项目凭借其在开源领域所做出的突出贡献、技术特性、社区影响力，受到业内广泛关注和认可，获得2022东北亚优秀开源项目、InfoQ 2022年度十大开源新锐项目、CSDN年度开发者社区、51CTO 卓越影响力技术团队等奖项。

OopenEuler开源项目当前已发布2个长周期版本、5个创新版本，下载量已突破100万，代码仓库9571个，代码行数约10亿行，软件包3.1万个，社区贡献者已发展至1.3+万名，建立了近百个SIG工作组，新增360+名开发者加入社区参与贡献，社区用户超过109万，企业伙伴超过750家，基于该项目的软件产品的市场占有率位居前列。

开放原子开源基金会联合阿里、CSDN共同研发自主、先进、中立的代码托管平台——AtomGit，目前已经完成了基础研发工作，基本实现代码托管平台基础通用功能。

开放原子开源基金打造了开放原子全球开源峰会，开发者大会、技术沙龙等品牌活动，汇聚全球顶级开源专家，推动开源理念和开源文化的广泛传播。

开放原子开源基金会推动“校源行”公益项目落地生效，推出了开源导师培养计划和校源行“1+4+X”课程体系，招募224名开源大使，对十数所重要学校进行资助。启动开放原子开源大赛，打造开源领域国际知名赛事平台。积极开展“源译识”开源翻译项目、“源规律”开源公益课程项目、“心寄源”开源法律沙龙项目三个开源法律公益项目。为广大公众和从业者提供国际主流开源许可证协议的可信中文译本，录制开源公益课程、探讨开源法律专业内容，推广开源合规知识。

开放原子开源基金会一方面组建开源安全委员会，制订委员会章程、运营机制及发展规划，明确开源软件漏洞发现和修复、SBOM分析等重点工作计划，目前已经有26家单位加入；另一方面持续完善TOC管理制度，完成TOC换届工作，优化项目捐赠流程和毕业流程。铜锁、MiniBlink、开源大师兄等15个基金会项目通过TOC投票，进入孵化。指导OpenHarmony、openEuler申请成为项目群，逐步走向社区开放治理。

![开源安全委员会](https://img-blog.csdnimg.cn/e83118c0f8be4401b0aca7f5cf447a6e.png#pic_center)
 
<center>开源安全委员会</center>



#### 重庆天工开物开源基金会

天工开物开源基金会是由重庆市政府批复设立，由清华大学，华中科技大学，重庆大学，中冶赛迪，中国信科，中科院等知名高校和企业联合发起，致力于推动中国开源事业发展的非营利机构。基金会作为产业公益性服务机构、开源项目管理机构，致力于提升国产工业软件和人工智能等卡脖子软件在开源领域的贡献地位，遵循共建、共治、共享原则，系统性打造开源开放框架，搭建企业、高校开源社区，提升软件行业及应用单位的协作效率，赋能千行百业。天工开物开源基金会专注于开源软件的推广传播、法务协助、资金支持、技术支撑及开放治理等公益性事业，促进、保护、推广开源软件的发展与应用；致力于推进开源项目、开源生态的繁荣和可持续发展，提升开源事业对软件产业发展的贡献。目前，基金会业务范围主要包括募集资金、专项资助宣传推广、教育培训、学术交流、校企合作、开源生态建设、咨询服务等业务。

2023年5 月 13 日，以“天工开物，面向未来”为主题，由重庆市发展改革委、重庆市科技局、重庆市经济信息委西部科学城重庆高新区管委会、中国人工智能学会联合主办，天工开物开源基金会承办的开源未来发展峰会在重庆隆重召开。本次峰会邀请到重庆市副市长张安疆、中国工程院院士倪光南、中国开源软件推进联盟名誉主席陆首群、Linux 基金会执行董事 Jim Zemlin 以及天工开物开源基金会理事长田广礼在会上致辞。

在峰会主论坛中，天工开物开源基金会携各大厂开源专家一同发表了《天工开物开源基金会联合产学研用各机构发布开源战略合作重庆宣言》并宣布了多项与开源社区的合作共建项目：天工开物开源基金会与中国开源推进联盟共建开源平台、天工开物开源基金会与开源指南针项目合作共建开源评估生态、Linux Foundation 开源软件学园渝源社区落地、天工开物开源基金会与开源中国代码托管合作共建等。这些合作共建将促进汇聚全球的优秀开源项目，推动开源技术的创新与发展，为中国的开源社区提供一个全新的交流、学习、创新的空间；进一步为开源评估生态的健康、快速发展带来助力；更深层次地体现了我们对国家开源事业的投入和贡献，对打造独立可控、安全可靠的国产软件生态环境的坚定决心。
作为一家致力于推动中国开源事业发展的非营利机构，天工开物开源基金会将始终坚守初心，遵循共建、共治、共享原则，不断助力国产工业软件和人工智能等关键软件在开源领域的崛起。聚焦开源技术前沿与生态革新，关注开源制造产业新生态，以开源赋能，以开源增效，探索科技软件转型新举措，联合开源无限新生态，推进开源项目、开源生态的繁荣和可持续发展，提升开源事业对软件产业发展的贡献。


### 6.1.2 综合新产业联盟

#### 中国开源软件推进联盟

2004年7月22日成立于北京的中国开源软件推进联盟（China OSS Promotion Union，COPU）由致力于开源软件文化、技术、产业、教学、应用支撑的企业、社区、客户、 大专院校、科研院所、行业协会、支撑机构等组织自愿组成的、民主议事的民间行业联合体，非独立社团法人组织。中国开源软件推进联盟的宗旨是为推动中国开源软件（Linux/OSS）的发展和应用而努力；为促进中国与全球关于开源运动（Linux/OSS）的沟通、交流与合作而努力；为促进全球开源运动（Linux/OSS）做出贡献而努力。截止目前，已经连续主办了17届“开源中国开源世界高峰论坛”和16届“中日韩三国IT局长OSS会议暨东北亚开源软件推进论坛”，成为最具国际影响力的中国开源组织之一。

#### CCF开源发展委员会

2021年12月17日，CCF开源发展委员会正式成立，旨在推动探索学术共同体主导的开源发展新途径，构建产学研项目成果共享孵化机制，加速产教研深度融合的开源生态建设。CCF开源发展委员会将重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，探索建立CCF开源项目孵化机制，培育原始开源创新项目，依托CCF联接科教资源、产业资源和社会资源等，形成产教研联动的开源创新模式，推动CCF开源品牌建设和开源社区运营，为CCF会员乃至全球开源创新实践者提供高水平的开源创新服务，助力我国开源生态建设的发展。CCF开源发展委员会在2022年承办了第一届CCF中国开源大会。

#### “科创中国”开源创新联合体

2021年1月18日“科创中国”联合体在北京成立，由中国科协科学技术传播中心、中国电子学会、腾讯、百度、麒麟软件、CSDN等36家单位共同发起。联合体以打造自主开源生态为宗旨，以建设产学研深度融合的开源创新体系为目标，以营造中国开源文化、提升开源创新能力为导向，广泛联系开源领域政、产、学、研、金、介、用、媒等各类创新主体，汇聚开源创新资源，发展自主开源基金，建设开源实验室、开源社区、开源创新示范基地等新型融合机构，拓展国际科技创新合作，建设“共商、共建、共享、共生、共赢”的科技共同体。截至2022年5月，“科创中国”开源创新联合体理事单位共有37家。

### 6.1.3 专业型开源组织

#### 新一代人工智能产业技术创新战略联盟

2017年7月23日，为配合新一代人工智能发展规划，支撑人工智能产业技术创新，营造健康有序、充满活力的人工智能应用生态，由北京大学、中关村视听产业技术创新联盟等联合倡议，在科技部试点联盟--数字音视频编解码（AVS）产业技术创新战略联盟的基础上，正式成立新一代人工智能产业技术创新战略联盟。发起成员单位包括百度、阿里巴巴、腾讯、华为、中兴、京东集团、传化集团、科大讯飞等知名企业，北京大学、清华大学、浙江大学、北京航空航天大学等著名高校科研院所及深行资本、将门投资等投资机构。

#### 绿色计算产业联盟

2016年4月，在工信部指导下，由华为、Arm、联想、戴尔（Dell）以及中科院计算所、北京大学、北航、电子标准院等17家国内外知名企事业单位，共同发起组建成立了绿色计算产业联盟。绿色计算产业联盟，英文名称为“Green Computing Consortium”，简称“GCC”。目前，GCC已有单位会员135家。愿景是顺应软件开源与硬件开放的信息技术发展趋势，汇聚全球产业链优势资源，以ARM计算芯片等开放技术为基础， 为最终企业用户提供更容易使用和管理的绿色节能产品。

#### 工业技术软件化开源社区

工业技术软件化开源社区是由国科开源工业互联网科创中心（湖北）有限公司建设的目前国内最大的工业技术软件化开源社区，是集企业和开发者开放交流服务、产学研创新服务、智能制造专家咨询服务、制造企业与软件企业对接服务、开源许可协议与知识产权保护服务于一体的开源技术平台。致力于提高国内工业互联网技术的自主创新能力，为国内工业互联网技术开源能力的提高和开源生态环境的优化提供长期推进的平台。

#### 云计算开源产业联盟

2016年3月9日，由工业和信息化部信息化和软件服务业司指导，中国信息通信研究院联合多家云计算开源技术公司发起，中国通信标准化协会代管的云计算开源产业联盟（OSCAR）在京成立。云计算开源产业联盟是业界首个专注于云计算市场的开源产业联盟，旨在推进OpenStack等开源技术在中国的产业化进程，加速中国云计算产业的创新发展。

#### 中国开源云联盟

中国开源云联盟（COSCL）成立于2012年8月，在工业和信息化部信息化和软件服务业司指导下，挂靠在中国电子技术标准化研究院，现有180余家开源生态圈产、学、研、用成员单位。中国开源云联盟（COSCL）作为国家重点研发计划《云计算和大数据开源社区生态系统》项目的指定开源组织，致力于联合国内开源产业界相关方，在中国共同推动开源生态系统搭建、技术社区建设、开源项目培育、开源团体标准研制、开源技术推广应用、以及开源人才培养等工作，是国内主流活跃的开源技术组织之一。

#### 中国人工智能开源软件发展联盟

2018年7月1日，中国人工智能开源软件发展联盟（AIOSS）是中国电子技术标准化研究院在工业和信息化部信息化和软件服务业司的支持下成立，以推动我国人工智能开源软件技术和产业发展为重要使命，搭建产学研用合作平台，促进联盟成员的研发、设计、生产、集成、服务等水平的提升，着重从政策、标准、技术、人才、公共服务、国际合作等方面加强我国人工智能开源软件生态圈的构建。

#### 中国开放指令生态(RISC-V)联盟

2018年11月，中国开放指令生态（RISC-V）联盟在世界互联网大会上成立，中国科学院计算所倪光南院士任理事长。该联盟旨在召集从事RISC-V指令集、架构、芯片、软件、整机应用等产业链各环节企事业单位及相关社会团体，自愿组成一个全国性、综合性、联合性、非营利性的社团组织。联盟将围绕RISC-V指令集，以促进开源开放生态发展为目标，以重点骨干企业、科研院所为主体，整合各方资源，通过产、学、研、用深度融合，力图推动协同创新攻关，促进RISC-V相关技术和产品应用推广，探索体制机制创新，推进RISC-V生态在国内的快速发展，从而使我国尽快摆脱核心芯片设计、知识产权、工艺技术等受制于人的不利局面。

#### 中国RISC-V产业联盟

2018年9月，中国RISC-V产业联盟成立，聚焦于RISC-V产业落地。它由国内外RISC-V领域重点企业、研究机构、和行业协会发起成立，目前已有50余家RISC-V领域相关企业以及10余家大学和研究机构加入。中国RISC-V产业联盟秉承开放、合作、平等、互利的原则，致力于解决中国RISC-V领域共同面对的关键问题，建立中国国产自主、可控、安全的RISC-V异构计算平台，促进形成贯穿IP核、芯片、软件、系统、应用等环节的RISC-V产业生态链。

#### 开源工业互联网联盟

开源工业互联网联盟（Openii Consortium）成立于2018年12月25日，由工业4.0研究院作为主要发起单位，以帮助中小制造企业实现创新发展为主要目标，采用开源软件和硬件的运行模式，加强利用数字孪生体系列技术来推动开源工业互联网的广泛应用。目前开源工业互联网联盟设有五大板块，分别为参考架构工作组、数字孪生体中心、开源项目中心、INNOBASE VENTURE和知识产权工作组等。工业4.0研究院负责数字孪生体中心的相关研究工作。

#### 开源GitOps产业联盟

2021年5月27日，在中国信息通信研究院云原生产业大会上，极狐与CNCF联合发起并成立“开源GitOps产业联盟” (Open GitOps Industry Alliance，OGA联盟）。OGA联盟为进一步推动中国开源、开放GitOps技术在各“产学研”领域的规范化实施和落地，以GitOps技术应用实践为核心，遵守“开源、开放、可信、自主、创新、共赢”的理念，致力于推动开源、开放GitOps技术的产业化发展，着力于构建具备国际技术竞争力、自主可控合作共赢的良好生态。

### 5.1.4 地区型开源组织

#### 北京智源人工智能研究院

北京智源人工智能研究院（简称“智源研究院”）是落实“北京智源行动计划”的重要举措，在科技部和北京市委市政府的指导和支持下，由北京市科委和海淀区政府于2018年11月推动成立。愿景是聚焦原始创新和核心技术，建立自由探索与目标导向相结合的科研体制。推动人工智能产业发展和深度应用，改变人类社会生活，促进人类、环境和智能的可持续发展。

#### 上海开源信息技术协会

上海开源信息技术协会是开源创新专业性非营利社会团体法人，成立于2022年3月。协会坚持第三方服务平台定位，立足上海，服务全国。基于自组织创新创业共同体模式，以专业、公开、公正、透明精神，积极发挥企业与政府之间的桥梁和纽带作用，服务国家及上海市数字经济发展战略，推动构建国家“自主、可控”数字经济创新创业公共基础设施。正在推动的主要工作有：开源理论及方法论构建、中国开源创新社会工程、上海开源产业园区、数字“一带一路”。

#### 深圳市开源技术服务中心

深圳市开源技术服务中心是立足深圳，面向全球的“民非组织”，为开源项目提供包括生态发展、运营、营销、法务、培训教育等基础服务是我们的服务重点。

#### 上海白玉兰开源开放研究院

2020年7月11日，上海白玉兰开源开放研究院正式揭牌，上海白玉兰开源开放研究院是由上海交通大学牵头，联合中国电子技术标准化研究院、北京大学、机器之心、复旦大学、华东师范大学、开源社、上海人工智能研究院有限公司等单位成立，对标国内外知名开源开放平台，建设世界一流开源开放平台。上海白玉兰开源开放研究院的目标是推动人工智能开源产品的国际规则互认，催生国际开源生态网络关键节点，建立系统验证与合规评测实验室形成国际标准。

#### 北京开源创新委员会

北京开源创新委员会成立于2021年10月，成员包含百度、腾讯、小米、京东、滴滴、地平线、CSDN、统信、PingCAP、中兴等近30家单位。它是在中国开源软件推进联盟、“科创中国”开源创新联合体、北京市科学技术委员会、北京市经济和信息化局、北京科学技术协会指导下，由开源企业、开源爱好者自发形成的民间公益团体。主要工作内容是发挥北京资源优势，促进开源产业合作、加强开源文化布道、跟进开源深度技术；协助企业开源转型、提升社区开源治理、规避潜在开源风险。

#### 北京开源芯片研究院

北京开源芯片研究院是成立于2021年12月的民办非企业，由一批行业龙头企业和国内顶尖科研单位共同牵头发起成立的创新联合体。研究院以开源开放凝聚产业发展共识，以协同创新激发应用牵引潜力，着力推进RISC-V创新链和产业链的加速融合，加速科技创新成果产业化落地，加快打造全球领先的RISC-V产业生态。研究院致力于研发 RISC-V 领域关键共性技术、建设关键支撑平台、优化生态治理、推动重点行业规模商用，加速 RISC-V 生态完善成熟，打造全球领先的 RISC-V 产业生态。研究院将围绕“香山”开源高性能 RISC-V 处理器核与“一生一芯”人才培养计划开展工作。

#### 厦门市开源芯片产业促进会

厦门市开源芯片产业促进会是成立于2022年7月6日的民办非企业，在厦门火炬高新区管委会和集美区政府联合指导和支持下，由中科（厦门）数据智能研究院牵头，厦门半导体工业技术研发有限公司（工研院）、厦门算能科技有限公司（比特大陆子公司）、厦门芯阳科技股份有限公司、厦门狄耐克智能科技股份有限公司联合发起设立，并作为中国开放指令生态（RISC-V）联盟的地方分中心，其主要宗旨是为厦门本地和外来引进的集成电路及相关的行业优质企业在开源芯片的产品开发、生产和应用及项目投资与合作等方面提供信息、人才、资金、技术、投资、政策等相关支持与服务，促进会目前有51家会员单位。

### 6.1.5 开源推广型社会组织

#### 开源社

2014年10月16日，由中国支持开源的企业、社区及个人所组成的开源联盟“开源社”正式成立，旨在携手国内社区、企业、高校及政府相关机构，共同促进中国开源社区成为全球开源软件的积极参与者和贡献者，并推动开源软件生态体系的健康可持续发展。同时，开源社将致力于促进中国开源软件和开源硬件的正确使用、授权许可、社区建设及管理，并为国内广大开发者提供教育培训、知识普及、工具及相关服务，全面满足中国新兴软件行业日益增长的现实需求。

#### ALC-Beijing和ALC-Shenzhen

ALC-Beijing和ALC-Shenzhen是遵照Apache软件基金会Local Community原则，并在Apache软件基金会申请通过的，面向北京和深圳的Apache本地开源社区组织。ALC-Beijing的发起人姜宁为了进一步推动Apache文化在国内的传播，并促进Apache本土项目和开发者的交流和合作，发起该组织，得到了Apache软件基金会的认可。目前该组织包含10多个Apache顶级项目，包括Kylin、Eagle、RocketMQ、ServiceComb、Griffin、SkyWalking、Dubbo、ECharts、APISIX、IoTDB、ShardingShpere、DolphinScheduler、Pulsar等。至今该组织海内外讲师180+，参与直播人数超过60万。2022年发起人姜宁当选为Apache软件基金会董事。

#### 腾源会

腾源会是腾讯云成立的汇聚开源项目、开源爱好者、开源领导者的开放社区，致力于帮助开源项目健康成长、开源爱好者能交流协助、开源领导者能发挥领袖价值，让全球开源生态变得更加繁荣。

#### 星策开源社区

星策开源社区是一个聚焦于企业智能化转型，由企事业单位、高等院校、科研单位、非营利性组织等按照自愿、平等、开源、协作的原则组成的非盈利性、中立的开源社区。联合发起单位包括中国开源软件推进联盟（COPU）、信通院、LF AI & DATA基金会、腾讯、微众银行、中兴通讯、蒙牛、工商银行、第四范式等。社区的使命是连接企业和AI，以开源的方式共享共建企业智能转型的方法论、案例、实践和技术，助力企业智能化转型成功。

#### 开放群岛

开放群岛（Open Islands）开源社区是由深圳数据交易有限公司联合国家智库、国家单位、高校、大型金融机构、大型互联网公司等近50家单位牵头成立的国内首个国际化自主可控隐私计算开源社区。以服务全国数据要素流通应用场景为目标，助力加快建设全国数据交易统一大市场，以开源开放的方式充分整合政府、企业、高校、科研机构等多方资源，推动数据要素流通，关键基础技术发展。

#### 西电开源社区

西电开源社区是一个以Linux为基础的，以技术交流和项目合作为主要活动的开源社区，是一群hacker和geek讨论、交流技术的地方，社区的精神是hacker精神，社区的点点滴滴都是靠hacker精神逐步迭代而来，社区的故事也无不体现了hacker精神社区倡导平等、开放、自由。努力为每一个酷爱技术的人提供良好的探索环境，使其兴趣得到充分发展。

### 6.1.6 企业开源办公室（OSPO）

#### WHAT - 什么是开源办公室
根据 TODO Group 的定义，开源办公室（OSPO， Open Source Program Office）被设计为组织的开源运营和结构的能力中心。这可以包括设置代码使用，分发，选择，审核和其他策略，以及培训开发人员，确保法律合规性以及促进和建立社区参与，从而从战略上使组织受益。

具体来说，「开源办公室」是企业在开源生态的标准化接口“API”，也是企业与企业间就开源生态合作实现沟通的标准化方式。对内，开源办公室可作为企业开源核心主体（例如开源委员会，开源技术委员会等形式）的「办事机构」，系统性的统筹企业针对开源的整体战略，并基于战略方向和投入打造相应的项目孵化机制，项目运营策略，通用开源工具，从而提高整体资源使用效率，以及企业开源的整体平均水位。对外，OSPO 所扮演的是企业在开源侧的“外交专员”角色，负责与涉及到政、产、学、研、用的开源生态，通过自身的专业性和价值主张，促进双赢多赢合作。

行业最早的开源办公室 OSPO可以追溯到 2004 年的 Google。在那之后，顶级软硬件公司例如 Microsoft，Intel，Facebook，Twitter，Square，Netflix 等也都成立了自己的 OSPO。Linux Foundation 2014 年成立了 TODO Group，作为 OSPO 的社区开始发挥长期价值。截止到目前，国内的顶级互联网公司如百度，蚂蚁集团，字节跳动，华为，腾讯，阿里等，都拥有自己的开源办公室或功能类似的组织机构。而在非互联网公司，如金融，汽车，保险，工业互联网等头部公司，由于供应链依赖和对外开源的需求，也逐渐出现了 OSPO 的身影。

#### WHY - 为什么要成立企业开源办公室？

##### 「开源」是一件专业的事情

开源是一种新时代的软件开发模式，是开放领域的产品迭代方式，也是一种可以助力技术业务发展的商业手段。然而，如果不遵循开源的方法论与价值观，不专业的做开源，企业也可能会面临潜在的不合规许可证和软件库使用的合规风险，安全漏洞和信息泄露等安全风险，以及会让企业商誉受损的品牌、公关等风险。想做好开源，需要在系统性的通过开源带来实质帮助的同时，管控整体投入成本，而这是一件专业的事情，需要对开源自身的理解，对技术项目群一定的了解，以及对合规法务，供应链等领域的话语体系的熟悉。「开源」如安全，效能等类似，是一种专业的领域。「开源办公室」旨在通过合适的人员搭配，成为这样的一个能力中心，让专业的人来做专业的事情。同时可以通过沉淀标准化操作 SOP，成功案例等方式，来将这种专业性进行全域拓展。

##### 做好开源，企业的顶层设计和系统统筹必不可少

正如《开放式组织》红帽实践所展示的那样，开放式组织是企业做开源的一种究极形态。而对于大多数不具备类似开放性的组织来说，开源需要一种自顶向下的长期主义，是需要依托于技术战略，甚至是业务战略的长期可持续投入。只有顶层设计到位，才能形成互不猜忌，长期可持续的开放性。

而将这种顶层设计和统筹系统性落地，离不开跨团队，跨领域的横向内部合作。「开源」对于企业来说，首先是项目和代码，这一定与 CTO 的工作直接相关，同时，由于潜在合规、安全、商誉等风险的存在，对内对外进行项目和文化运营的需求，以及企业对于开源生态合作的整体需求，开源也与 CRO（首席合规官），COO（首席运营官）和 CMO（首席市场官）的工作有关。而企业需要协调统筹跨域的合作，一种比较高效的方法是成立一个对这件事情直接负责的保障组织，不管是技术委员会，工作小组还是其他的虚拟机构，都需要一个相应的“办事机构”。开源办公室 OSPO 就是这样的一个组织，负责协调资源，横向合作，将开源的整体战略贯彻落实。

一个精心打造的，由靠谱的负责人所领导的 OSPO，可以成为企业开源统筹和运营的核心能力中心。

##### 开源办公室可作为全局中立能力中心服务项目和技术

《大教堂与集市》彰显了打造优秀作品的两种组织形态，而开源的工程、产品及 GTM 方法，与企业常使用的软件开发模式，以及商业公司对收入的需求，时常会出现一些执行上而非理念上的不兼容。开源办公室可以从公司的长期主义出发与项目组进行配合，在项目组更关心短期业务结果的前提条件下，探索如何通过项目矩阵，运营策略，产品化和生态合作等方式，空间维度上形成更多的项目组合作，时间维度上关注更长期的用户价值，并通过开源社区，基金会，联盟和三方生态，将这种布局加速和拓展。

一言以蔽之，OSPO 是企业开源的催化剂，而不是化学反应本身。开源项目自身还是要回到切实解决社区核心问题上，为问题领域带来价值，这种价值是社区认可项目的的 “化学反应”。

#### HOW - 开源办公室如何助力公司开源业务
作为公司层面对开源负责的办事机构，OSPO 在开展业务的时候，需要对顶层设计，战略统筹，开源治理，开源运营，及社区商业生态五个核心维度的成功负责。以下是关于相关领域的具体理解：

##### （1）顶层设计

由于 OSPO 作为「成本中心」的特性，为了让开源这件事情能持续做下去，公司宜有针对开源的长期价值主张。开源应当是公司技术战略，乃至核心战略的延伸。Google 等公司将技术与开源有机结合在一起，开源是其技术能力的呈现；而 Microsoft 等公司则是将开源与云业务相结合，将开源做成其商业闭环必不可少的一部分；而硬件公司如 Intel 等则是通过开源形成强技术标准和护城河，并基于软件打造生态卖硬件。公司长期的开源坚持，离不开这样的顶层设计。

OSPO 在这个点上，关注的核心不是单个项目的繁荣，而是公司的核心价值主张，是否可以通过持续的项目开源，贡献上游等方式，来系统性的达成。OSPO 应将目标锚定到持续打造优秀的开源项目与社区，并在顶层设计层面带来一些推陈出新，全局视角的想法和探索，牵引新的优秀的技术社区出现。举个例子，公司的开源责任主体， 可以从顶层设计层面来判断某个技术领域是否要联合多个跨域团队来启动专项，从而助力业务层面的成功。不管是 ToB 的先尝后买，还是 ToB 的伙伴生态布局，都是可以带来长期业务结果的方式。开源办公室可以基于这个大逻辑，与项目组深入配合，来贯彻落实这种顶层设计。

##### （2）战略统筹

从公司角度出发，OSPO 是项目团队的合作方，是项目发展生命周期的深度参与者和关键决策的列席者。开源办公室作为对开源生态有关键理解的核心人物，一方面应当将战略统筹能力中标准的部分抽象称为最佳实践和培训，让开源统筹成为一个公司维度易得的能力，实现整体最低水位的提升；另一方面，OSPO 应当深入到核心项目中去，要对项目社区和定位有清晰的了解并参与共创，在不同阶段给出不同的治理，运营设计输入。毕竟头部项目的长期成功，对于公司开源心智的树立，是有着重大价值的。OSPO 可以通过市场洞察，案例沉淀等具体的方式，来帮助项目寻找 land and expand 的发起点，取得 project community fit 之后的拓展方式，以及有商业化潜力之后，如何通过开源体验来进行商业转化。

需要注意的是，虽然 OSPO 往往对于流程，机制有一定把控，但目标绝对不是“拦着人做事”的“衙门”。如何能够通过能力中心来服务全公司多样化的开源诉求，是 OSPO 作为一个战略向团队，是否能长期被业务所认可，需要一直做的核心思考。

##### （3）开源治理

也许会有人问到一个问题：一个公司有法务有安全团队，为什么还需要 OSPO 团队来投入开源治理工作？答案是，开源合规和开源安全，是整体合规与整体安全的一个细分领域。在这点上，OSPO 扮演的是“业务方”的角色，一方面负责提出核心需求，定义清楚“什么是好的治理目标”，另一方面需要通过全局视野，来保证交付的验收结果是可以实实在在长期满足业务需求的解法，而不是一锤子买卖。此外，合规和安全领域也具有较强的与时俱进需求，OSPO 应当紧跟行业最佳实践，寻求方法论和工具提效的机遇。

需要关注的点是，开源治理所涉及到的子领域，基本都是技术艰深的领域，在效能，合规，数据安全等维度，OSPO 本身不需要具备相应的核心关键能力（当然具备则是一种优势），而是应与各个业务团队一起，通过横向项目来确保系统性治理，比如针对合规新需求的改造，持续 license 合规工具等专项的落地。

##### （4）开源运营

每个开源项目组一般都会有自己的运营团队，而开源办公室关注的是作为资源的整体调配方，寻求 synergy 合作多赢，一方面由内而外促成整体合作，让公司的多个项目能够实现渠道和资源复用，持续达成 1+1 > 2 的效果；另一方面由外而内链接机遇，针对生态需求合理调用公司的开源能力或项目，作为生态合作伙伴对接方，因地制宜的为项目带来持续价值（开发者牵引，顶级机构曝光，关键机构合作等）。

OSPO 作为公司的「开源外交代表」，要想有效牵引与开源生态合作伙伴的交往，必须要自身具备一定的专业判断能力，同时对于内外部的项目方和生态合作方的能力和需求有所了解，才能够通过认知带来双赢合作。

而开源办公室在运营侧所需要的另一个核心思考能力，则是代表公司的整体「布道」能力。开源办公室的负责人，本身首先要是开源的布道师，同时也是公司开源理念，开源项目整体阵型，以及开源整体战略的布道师。

##### （5）社区商业生态

虽然开源本身并不能带来收入，但灵活将开源的策略融入商业模式，通过工程合作，产品迭代来降低成本，并通过商业手段来协助项目组打造可持续的商业模式，是开源办公室能为公司带来潜在收入，证明其价值的一种核心方式。在开源商业化这件事情上，开源办公室一方面可以扮演生态拓展方的角色，通过基金会，合作伙伴，和社区 KOL 的关系来直接助力业务的生态扩张；另一方面，由于覆盖范围广，开源办公室自身也可以通过项目案例的沉淀，红黑榜的打造，以及洞察或市场分析等方式，为项目组带来独特的发展洞见。OSPO 可以作为「空军」提供生态合作对接和支持，也可以作为「陆军」与合作伙伴一起，共同推动项目产品化到商品化孵化。

诚然，开源办公室不可能越俎代庖，来全面提供 BD 或 partnership 的全套支持。在这些维度上面，作为一个横向团队，提供专业输入，渠道能力和开源深度视角，宜作为开源办公室重点关注的发展方向。


## 开源项目办公室（ OSPO）的现状与挑战
作者：LFAPAC  OSPO SIG 、OSPO Group、Red Hat OSPO

以共同体（Community）的形式集体行动的软件生产方式——开源，以其适应现代数字的知识和智力发展而占据了驱动世界前进的一席之地，而更早的以资本驱动的企业，无论多么的不情愿，都无法阻止开源软件成为自己的重要支柱。但是，在获得利益的同时，伴随而来的是问题：合规（Complicance）、安全、技术债务、人力管理、工程效率等等诸多无法回避的内容。当然，人并非被动的接受无力感，而是主动的寻求最佳的平衡之道。

### 开源避无可避与企业的对策：开源项目办公室的崛起

log4shell 安全事件[2]将开源强行拉到了公众视野，除了企业瑟瑟发抖之外，也引起了国家的重视，正如本蓝皮书所做的调查，开源已经是现代数字世界的重要基础设施，一些智库已经接受了开源项目就是我们物理世界的道路与桥梁的观念[3]。

随着企业使用大量的开源项目，那么也意味着，不能当作可有可无的事情，而是影响企业战略和业务的重要事项。但是，开源世界的法则和企业的运行法则有非常大的不同[4][5]。对于《开放式组织》[6]来说，传统意义上的企业实在是无法践行，于是，在企业内成立一个专门处理开源相关事务的职能实在必行：

●开源项目办公室（OSPO）的崛起， Nithya Ruff，下载地址：https://academic.oup.com/book/44727/chapter/378968614?login=false

●开源项目办公室（OSPO）的崛起，Hussan Munir 和 Carl-Erik Mols合著，下载地址：https://ieeexplore.ieee.org/document/9340079/

●开源项目办公室的演化，Chris Aniszczyk TODO group ，下载地址：https://www.linuxfoundation.org/research/
the-evolution-of-the-open-source-program-office-ospo

###业界实践与理论形成

开源项目办公室并不是来自于人们的主观想象，相反，它来自于企业的实践，正如开源的先驱Eric S Raymond 所论断的那样：

对开源开发完整而充分的认识应该建立在其工程和经济上的结果——质量更好、可靠性更高、成本更低、选择更多。......由于开源软件的存在，任何软件技术的最终命运不是灭亡就是成为开源基础架构的一部分。
     —— 《大教堂与集市》[7]

是开源项目已经为企业所用，然后随着业务的发展才出现的问题。在商业的世界里，信任起着至关重要的作用，那么遵循服从开源许可的刚需伴随着开源项目的引入成为企业必须关注的一部分工作，而且随着日积月累的增加，开源项目占比整体软件栈的升高，许可的兼容性成为了另外一个突出的问题。这也意味着业务对于开源项目的依赖日益增加，业务的变动，会导致整个软件栈受到影响，可谓是“牵一发而动全身”，换句话说，现代的企业很少有不依赖开源而开展相关活动了，甚至有的企业利用开源来赢得技术标准，成为市场的领导者。

对于 OSPO的定义，我们以TODO的为基准[8]:

开源项目办公室（Open Source Program Office），旨在成为一个组织的开源业务和结构的能力中心。目的是帮助企业在开源软件的使用、支持、参与、开发等方面开展企业级的开源战略，同时也帮助企业了解开源软件的优势和潜在的威胁，以及思考如何平衡各方因素来满足公司的业务目标。

OSPO 的另一个关键角色就是涉及审计许可合规性，以确保企业满足开源软件的各种许可要求。包括：企业如何为开源社区做出贡献，或者将哪些内容释放回社区，以及评估开源技术如何为企业的业务带来价值。

**已发表的论文、白皮书等材料汇总**

1.OSPO 101  在线阅读地址：https://github.com/todogroup/ospo101

2.《技术债务与开源开发中文版》电子书，下载地址：https://training.linuxfoundation.cn/downloads/596aaa96562f6c545899b26bf3f63d86

3.《深入理解开源项目办公室 中文版》电子书，下载地址：https://training.linuxfoundation.cn/downloads/d1895d027c54a9e56ff41d428289b9ea

4.《开源项目办公室的商业价值》，下载地址：https://www.linuxfoundation.org/research/business-value-of-ospo?hsLang=en

5.中国信通院编写了《2022年OSPO案例汇编》于2022年9月发布

6.OSPO 联盟发布： The Good Governance Initiative 

### 交流活动与相关组织

没有一把钥匙可以打开所有的锁，也就是说OSPO对于每个组织都是不同的，每个组织需要根据自身的需求和场景来实施不同的OSPO策略，正如管理学那样，组织之间需要相互的借鉴和沟通，保持知识的流动，那么相关的活动、研讨会、见面会就显得越发重要。以下是我们目前收集到的相关活动。

**OSPO Summit**

2023年3 月，由中立组织OSPO Group和Linux Foundation APAC 布道者团队OSPO SIG 发起，来自不同公司和组织的 20 余人参与筹备的首届OSPO Summit成功举办。以本地化与全球化为主题，来自全球OSPO 的领先实践者们围绕 Upstream First Practice 和 OSPO 工作实践等两大方向进行了精彩的分享，旨在让依靠开源的企业能够分享、学习、总结经验，让各方都能受益，尤其是从业者能够成功。本届峰会共设有 1 个主论坛，2 个分论坛，4 个主题圈讨论，和别具一格的午餐观影、晚宴及夜谈活动，国内外开源先锋齐聚一堂，共享全球智慧，引领开源发展。

**OSPOCon**

OSPOCon 旨在让使用开源技术的组织、企业、机构，尤其是设置了专门的开源项目办公室的，能够相聚一堂，彼此学习和分享关于开源的最佳实践、经验教训、以及应对所面临的挑战。所发起的大型会议。

OSPOCon 由Linux基金会、TODOGroup、OpenChain等提出并积极推动。

目前为止OSPOCon 分别为：OSPOCon 北美、OSPOCon 欧洲、OSPOCon 日本，以及我们新引进的 OSPOCon 中国区大会。已经举办过的大会有

●OSPOCon NA，在美国西雅图，举办时间2021年9月27到9月29日

●OSPOCon EU，在英国伦敦，举办时间2021年10月6日

●OSPOCon NA，在美国奥斯汀, 举办时间2022年6月21日

●OSPOCon EU，在爱尔兰都柏林，举办时间2022年9月14日

●OSPOCon Japan，在日本东京，举办时间2022年12月5日

●OSPOCon EU，在荷兰阿姆斯特丹，举办时间是2023年4月20日

●OSPOCon NA，在加拿大温哥华 ，举办时间2023年5月10到12日

●OSPOCon China，中国上海，举办时间2023年05月28日

**TODO Group 介绍**

TODO 工作组 是一个由 70 多个组织组成的开放工作组，他们拥有多年的开源项目运作经验，希望在实践、工具等他方式上协作来成功、高效地运作开源项目/计划。它是一个通过分享经验、制定最佳实践和指导以及开发通用工具的地方，进而推进全球各环节采用 OSPO 和教育。如果想了解更多进行中的 TODO 计划的信息参考这里 此处 ，并查看 OSPO 一览图 https://landscape.todogroup.org

**OSPO Group 介绍**

OSPO Group 是由个人志愿兴趣而成的虚拟团体，成员均来自从事开源项目办公室[]相关,来自企业、开源共同体、高校、政府智库、媒体等，秉承「推动组织拥抱开源，加速企业开源协作」目标，做一些力所能及的事[9]：

●LF APAC OSPO SIG 的日常分享与沟通，这是事情发生最早的地方

●LFAPAC 开源布道者开源万里行活动，非常受欢迎的知识、经验分享活动

●TODO Group 本地 Adopter ，作为国际经验输入和本土经验输出

●OSPOCon China

●OSPO Summit

●面对面的拜访

●年度聚会，分享得失

**OSPO 联盟**

●名称:OSPO Alliance

●发起时间/发起方: 2021.6月,由欧洲非营利组织及企业发起

●地域范围:欧洲为主,面向全球开放

●网址:https://ospo.zone/

●会员义务:签署协议即可,无需缴纳费用

●运作:

研究报告

旗舰大会: 暂无

[](https://img-blog.csdnimg.cn/360007ff35a145248ef695bf8488f1d2.png#pic_center)
https://ospo.zone/position-paper/

**成立开源项目办公室的组织（不完全统计，不断更新）**

| 组织名称 | 网站/公众号/社交媒体号等 |
| ------ | ------ |
| 蚂蚁集团 | https://opensource.antgroup.com/|
| 字节跳动| cell |
| 华为技术有限公司| https://www.huawei.com/en/open-source |
| Red Hat | cell |
| 中兴技术有限公司| cell |
| 中国信息通信研究院云大所| cell |



#### 阿里巴巴开源办公室实践

阿里巴巴开源办公室的主要职责是与开源委员会互相配合，把开源委员会制定的技术战略在阿里巴巴落地和执行，并保障更多开源项目的治理和运营。通过制定规则及流程机制，对团队进行核心培训从而明确底线，并且做到有迹可查，全面提高技术同学的安全合规意识，加强开源社区的规范建设和管理，保障阿里的开源项目安全、可靠地为开发者、企业服务。

**2022年重点进行了三方面的工作：**

1.将开源与企业核心的业务战略或者技术战略相结合，从之前“自下而上”的开源模式逐步转变成“自下而上、自上而下”二合一的模式，以此来保障阿里明确战略方向上要投入的开源软件不会出现后续无人维护的情况。

首先，新的项目要开源，需要该领域的开源委员会副主席进行技术判断；其次，对于团队内自下而上的开源模式，阿里巴巴依旧全力鼓励，并会给与一定的孵化资源，自上而下不意味着严格控制开源，而是要在鼓励开源开放的同时，做好治理与扶持工作。最后，从项目管理视角建立完善的开源项目治理框架，对开源项目分阶段、分类型进行精细化治理，建立系统的业务平台，有效厘清与甄别开源项目的生命周期，对处于不同阶段的项目进行具有针对性的治理与指导工作。

对于孵化期开源项目，做到能开尽开，保证法务、安全合规工作，加强开发团队的开源教育与指导，扶持社区健康快速发展。对于稳定发展的开源项目，做好规模化社区的流程建设，加强社区中的技术合作与发展，持续服务好社区用户。对于因技术或业务原因停止维护的项目，设计开源项目的退出机制，做好社区通知声明与项目归档工作，站好最后一班岗。

通过上述治理工作，在鼓励自下而上开源开放的同时，保证自上而下的宏观治理工作有序落地，在保证项目质量与生命周期管理中加速阿里的优秀内部技术实践往开源转化，为开源技术生态的发展添砖加瓦。

2.通过战略引导明确核心开源领域，并设置多领域的负责人共同评估、判断某一开源项目，并推进开源战略的落地。为了保证开源项目的专业性判断，开源委员会一共新设立了 9 位领域副主席，可称得上是各自领域的“一号位”，除了深厚的技术专业知识，他们本身就具备足够多的团队及资源，可以帮助公司内部做出更好的技术支持及专业判断，从而帮助相关技术领域孵化出更多创新产品，为行业输出更多优秀的开源项目。

3.对存量开源项目进行更全面、规范的治理。夯实阿里巴巴“开放、有序、踏实、利他”的开源文化，让阿里巴巴的开源行动也需要变得更加有系统、有组织、可持续。

**两大活动**

**编程之夏：**

2022年5月30日，第三届阿里巴巴编程之夏面向高校学生开放报名，阿里巴巴编程之夏（ASoC）是面向全球18岁及以上本科、硕士、博士高校学生的技术普惠计划，它旨在鼓励高校学生深度参与开源开发活动，激励学生以第一视角感受开源世界的魅力。ASoC 以阿里巴巴开源技术力量作为媒介，为高校学生们和开源社区搭建桥梁。

本次活动获得CCF开源委员会秘书长章文嵩、Apache Software Foundation 董事吴晟等开源圈大佬点赞转发，发布后有北大开源协会、清华TUNA开源协会、西电开源协会等学生社团主动接洽。除了国内顶级高校清华大学、北京大学、中国科学技术大学等，top20 985高校覆盖率达到了85%以上。另外还有14所国际高校学生报名。包括约翰霍普金斯大学、卡耐基梅隆大学、加州大学圣地亚哥分校、纽约大学、东北大学、伊利诺伊大学厄巴纳香槟分校、巴黎综合理工学院、加拿大阿尔伯塔大学、欧洲英国诺丁汉大学、丹麦科技大学、印度德里技术大学等。和往届编程之夏相比，覆盖项目领域从前端、云原生、大数据领域扩展到 操作系统、大数据、数据库、云原生、前端、人工智能等热门领域。项目数量从去年的20个增加到27个，开放任务数量从62个增加到96个。

**开源开放周：**
2022首届阿里开源开放周Alibaba Open Source Week于2022年8月22-24日以线上的形式亮相，邀请了业界顶尖技术专家学者，与阿里开源领军人和头部项目代表共同探讨开源领域的最佳实践和新机遇。本次开源开放周，在主论坛之外，还特设了 5 大分论坛，聚焦操作系统、数据库、云原生、大数据、终端 5 个领域，帮助开源人探索技术开放生态的更多可能。

在主论坛上，阿里巴巴开源委员会分管委员蒋江伟分享《阿里开源的动与势》，介绍了阿里巴巴开源的历史，分为使用、贡献、开拓三个阶段，阿里在创业早起就大量使用开源软件，阿里技术的发展也根植于开源的沃土中。当阿里在大规模互联网系统和云的研发中，积累了越来越多的技术经验，解决了越来越多的新问题之后，也积极地将自身的实践以开源软件的形态回馈到社区中。MongoDB 副总裁 Matt Asay 带来了《MongoDB 助力开发者实现高效开发》的分享，bilibili 技术委员会主席毛剑，也带来了《B 站在云原生与开源方向的探索与实践》的主题分享，并通过《数字世界已来，开源生态与未来》的圆桌讨论，邀请中国信息通信研究院云计算与大数据研究所副所长栗蔚，上海交通大学长聘教授、人工智能研究院总工程师、上海白玉兰开源开放研究院执行院长金耀辉，Apache 软件基金会首位华人董事、Tetrate 创始工程师吴晟，与阿里巴巴开源委员会秘书长、开源办公室负责人王晶昱共同展望了云与开源的更多可能。

另外五大分论坛也是干货满满，通过 2022 首届阿里巴巴开源开放周 Alibaba Open Source Week，阿里巴巴向业界分享了很多自身在开源中积累的实践经验，以及社区治理经验；同时，也通过自身链接了业内的技术专家及开源社区的负责人等，为开发者、开源爱好者们带来了极具价值和意义的内容。


#### Red Hat 开源项目办公室实践

Red Hat作为一家开源软件公司，也会面临其他企业在遇到开源软件时一样的问题，因此是最早成立开源项目办公室的企业之一，并且在企业内部持续良好运作、发挥了极其重要的作用。红帽的开源项目办公室在组织上隶属于CTO办公室，指导全公司范围内开源项目的运营、开源战略的制定，同时对外负责开源社区建设以及开源文化推广等，具体来说，主要负责以下几部分工作：

**●使组织目标与开源参与保持一致**

○一个组织或一个企业，肯定有其业务目标，企业的所有经营活动、投资，本质上都要围绕这个业务目标来进行，因此企业在开源上的参与和投入也不例外。近年来，开源软件在企业的业务系统中承担越来越重要的作用，可以说，开源无处不在。开源在企业里的呼声很高，但如何使开源参与和组织目标保持一致，是一个需要深入思考的问题，开源项目办公室，首先要根据企业自身实际情况，帮助企业想清楚这个问题。

○以Red Hat为例，Red Hat的开源项目办公室首先要解决的也是这个问题。有人可能会认为，Red Hat作为一家开源公司，需要解决的的问题和其他企业可能不一样；但从本质上来说，Red Hat需要解决的问题，和其他企业是共通的。 开源项目是海量的，Red Hat也要根据自己的业务目标，选取有价值的项目，确立投资的重点，同时还要帮助组织定义用于判断组织开源战略成功与否的关键指标。

**●倡导组织的开源战略**

○接下来，开源项目办公室需要帮助制定开源战略，并在致力于通过开源取得成功的那些部门，无论是工程部门，还是销售部，营销部门，倡导组织的开源战略，达到战略协同。比如，如何认识与上游项目协作的好处，比如大家所熟知的Upstream First, 如何让各部门的人深入理解并有效实施。

○需要指出的是，Red Hat作为一家纯开源的软件公司，所有项目和产品都是100%开源的。但对于一般企业来讲，往往是部分软件开源或者参与或使用了第三方的开源软件项目，因此广义的开源战略往往包括从战略上决策哪些软件要开源，为什么要开源；要选择哪些第三方的开源软件，是社区的开源软件还是企业级的开源软件；等等。

**●维护开源许可证合规性并提供法律监督**


○谈到第三方开源软件的选择，就不可避免的会遇到开源许可证合规等问题。许多开源项目办公室维护开源许可证合规性，并对组织使用开源软件进行法律监督。组织必须确保他们遵守管理他们使用的软件应用程序的许可证——无论该软件是如何获得许可的。 使用开源许可证在本质上并不比使用任何其他类型的软件许可证更具风险，但首次接触开源的组织可能会对开源软件许可证和专有软件许可证之间的差异有疑问。

○开源项目办公室扮演着回答这些问题的重要角色，确保组织遵守管理其使用的开源软件的各种许可证。这项工作通常涉及对所有活动的、现有的和传入的代码（以及其他公开许可的材料）进行软件许可审查，并帮助组织选择工具，使各部门的利益相关者能够更轻松地开展这项工作。

**●指导组织在开源共同体的工作**

○开源项目办公室还指导组织在开源共同体中的工作。对于使用开源软件的组织来说，社区是关键技术创新的源泉。 简而言之，与上游项目合作是获得开源项目创新收益的最佳方式。

○开源项目办公室具有确保组织制定的开源战略有效实施的职能，并提供必要的工具、流程，以及相关的培训，帮助开发者理解开源社区的运作机制，参与开源社区工作的方式方法和最佳实践，Red Hat开源项目办公室在这方面积累了大量的经验，并帮助公司内外的众多开发者从“社区小白”逐步成长为“社区大咖”。

**●促进与项目负责人、基金会和标准机构的关系**

○最后，开源项目办公室可以促进与项目负责人、基金会和标准机构的关系。

○成为一名优秀的开源公民意味着要做的不仅仅是为软件项目贡献高质量的代码。 它还意味着以帮助这些项目成长和繁荣的方式在开源社区中发挥积极和支持作用。例如，这可能意味着参与项目治理流程或参与或赞助监督项目成功管理的基金会。 开源项目办公室帮助组织确定将时间、精力和资金投入开源项目的最有价值的方式。

**极氪汽车开源办公室实践**

极氪汽车是吉利汽车、吉利控股集团于2021年4月推出的豪华纯电品牌。极氪高层高度重视开源，特别是开源合规风险管控。公司成立不到一年就在内部启动了开源治理项目，并积极推动了开源办公室（OSPO）的建成。

极氪OSPO组成人员涵盖了研发、安全、合规、法务、运维等人员，设置三层四组的人员架构，职责分工明确。其中三层指的是高层人员支持、中层人员指导、基础层人员执行的层级设置；四组指的是研发组、审核组、检测组、运维组。对内运营方面，极氪OSPO推动落地了四大事项：制度建设、流程落地、培训宣贯、供应商管理。其中在制度建设上，已经推动建立了开源软件合规管理制度、开源软件选型及引入管理规范等一阶二阶的制度，以及开源代理治理、引入场景和分发场景等具体指引文件作为指导，加强许可证风险、安全漏洞风险以及出口管制风险。

在流程落地上，开源合规和安全审核嵌入到devSecOps，已经建成开源组件引入流程，收口公司开源组件的引入，研发人员只需提供一个代码下载链接或直接通过极氪组件代码库进行识别引用；在分发前，通过SCA工具自动化扫描识别验证研发所做的合规安全措施是否落地。

在培训宣贯上，通过线上线下等课程培训进行培训，同时开通开源科普文系列。

在供应商管理上，极氪OSPO对公司软件/信息化相关合规模版进行调整，增加可落地的开源合规条款，并要求应用场景是外部项目和SAAS项目的供应商提供开源组件使用情况表或SCA报告；同时在DMZ流程中嵌入供应商引入代码的SCA扫描，确保供应商引入合规。

对外合作上，极氪OSPO参与了多项对外活动，首批加入中国信息通信研究院“可信开源合规计划”，参编了国内首份开源办公室案例集，并获得OSCAR尖峰开源企业（开源治理）奖以及开源合规领航者称号。

开源之路并非一蹴而就，极氪OSPO也正在考虑研究并推动内部项目对外开源，从使用开源，慢慢走向参与开源直至领导一些项目的开源，在开源生态中贡献极氪礼物。

我们也希望将极氪OSPO在开源领域的最佳实践，推广应用到汽车行业，影响供应商、集成商以及车企生产商，形成一个良性的与开源共舞的生态发展局面。

#### 总结

开源办公室 OSPO 方法论虽然已经有多年的沉淀和实践，但在公司所需要覆盖的业务场景，以及对于开源办公室能力，需求方面，并不存在一个所谓的“共识”。企业需要什么样的开源办公室，往往由企业自身的状态决定。但开源办公室需要解决的风险问题，项目内部孵化效率问题，以及生态合作的运营问题，还有项目群整体发展的统筹问题具备相应的共性，所沉淀下来的方法论也具备一定的普适性。TODO Group 在这方面做出了一些前沿探索，国内诸多的开源机构如开放原子开源基金会，开源社，木兰社区，LFAPAC 布道者，信通院开源产业联盟等也结合产业侧的具体实践，针对 OSPO 的方法论及案例进行了剖析分析和沉淀。根据目前的统计数据，国内企业将成立开源办公室作为「拥抱开源」的标准实践，是主流趋势。

**参考材料**

1.https://www.youtube.com/watch?v=5G6xzqIXJ4c , 最后访问时间：2023.4.26
2.https://openssf.org/blog/2022/12/15/avoiding-the-next-log4shell-learning-from-the-log4j-event-one-year-later/ ，最后访问时间：2023.4.30
3.https://www.atlanticcouncil.org/in-depth-research-reports/report/open-source-software-as-infrastructure/ ，最后访问时间：2023.4.30
4.《开源之迷》，适兕，人民邮电出版社，2022-02
5.《开源的成功之路》，Steven Weber，外语教学与研究出版社，2007-06
6.《开放式组织：面向未来的组织管理新范式》，[美] 吉姆•怀特赫斯特，机械工业出版社，2016-9
7.  《大教堂与集市》， [美] Eric S. Raymond，机械工业出版社，2014-5
8.https://github.com/todogroup/ospodefinition.org , 最后访问时间：2023.4.26
9.https://opensourceway.community/posts/open-source-conference/ospo-summit-what-is-ospo-group/ , 最后访问时间：2023.4.26




## 6.2 问题与挑战

中国的开源组织在过去几年取得了长足的进步，得到了政府和社会的广泛关注和支持。然而，随着近来国际形势呈现出的深刻、复杂、动荡的变化，以及技术创新的迭代升级加速，中国的开源组织面临着一些问题和挑战。

1.	**产业影响力不够。** 开源组织的质量、数量及其产业影响力是软件产业发展现状的直接反应。当前我国的开源组织主要参与者是国内的企业，国内软件产业整体发展质量不高，体现在开源组织方面，整体上产业影响力不够。
2.	**国际化程度不足。** 尽管中国的开源组织数量在不断增加，但是国际化程度相对较低，很多开源组织需要进一步提高在全球开源社区中的影响力和话语权。
3.	**对于开源与标准协同发展的认识不清晰。** 国际领先的开源组织都对开源与标准的协同发展有清晰的认识和明确的战略，在利用开源推动技术广泛应用的基础上，结合标准与合格评定机制建立技术品牌，维护开源社区的稳定发展。我国的开源组织应当加强对于领先组织的洞察，充分利用多种工具组合，扩大开源社区的影响力。
4.	**可持续发展能力不高。** 虽然中国的开源组织取得了一些成就，但很多组织还存在着融资困难、人才短缺、技术创新难度大等问题，尤其是缺乏商业化运作模式，无法将开源项目转化为商业价值。
5.	**缺乏知识产权保护机制。** 中国的开源组织普遍缺乏对知识产权的保护意识和机制，导致了知识产权的滥用和侵权现象，对开源项目的长期发展产生了不良影响。

面对这些问题和挑战，中国的开源组织需要不断探索和创新，加大开源人才培养力度，提高开源项目的质量和技术水平，加强与国际开源社区的交流与合作，助力中国开源生态向更加健康、成熟和具有全球影响力的方向发展。

## 6.3 发展趋势

在国家政策进一步利好的背景下，越来越多的第三方开源组织涌现出来，通过在中国民政部的全国社会组织信用信息公示平台（xxgs.chinanpo.mca.gov.cn）上查询，发现共有16家从事开源相关工作的社会团体、基金会和民办非企业单还处于正常运营中，其中近一年内成立的就有5家。还有多个依托基金会、学会、联盟、大学等机构的开源组织也于近期纷纷成立。中国的开源组织呈现以下发展趋势：

1.	**数量和规模将继续扩大。** 随着人们对于开源的认知和接受程度不断提高，越来越多的企业和组织开始使用和贡献开源软件和技术，开源软件和技术在国内的应用场景也在不断扩展，开源组织的数量和规模也将继续扩大。
2.	**国际影响持续增强。** 随着中国开源社区的不断壮大和国际化程度的不断提高，中国开源组织也将会加强与国际开源社区的交流和合作，推动中国开源组织在国际舞台上的影响力和地位。
3.	**社区治理和战略工具应用能力逐渐完善。** 随着开源社区的不断壮大，社区治理也变得愈发重要。开源组织开始加强对社区成员的管理和沟通，制定更加民主和透明的决策机制，提高社区的运作效率和质量；一些领先的开源组织提高了包括开源与标准协同战略工具的应用能力，建设与开源社区结合的标准化流程，在代码开发的同时，将支撑互联互通功能的接口标准化，并同步建立合格评定机制，支持开源技术的稳定演进。
4.	**开源硬件成为关注重点。** 除了软件领域，开源硬件也将成为一个重要的发展方向，近期北京和厦门都成立了专注开源芯片的开源组织并在属地民政局正式注册。随着开源硬件平台的不断完善和普及，越来越多的企业和个人开始利用开源硬件平台开发各种应用和产品。

## 6.4 发展建议

在国际形势愈发复杂的背景下，开源组织更应该不忘初心、坚守本心。从实践来看，坚守并践行中立原则的开源基金会与开源组织将赢得开发者以及合作企业的持久信赖。有鉴于此，建议中国的开源组织：

**一是继续扩大国际化合作，融入全球开源生态。** 开源是全球化的，加强与国际开源组织和社区的交流合作，吸引全球的优秀项目与开发者，推动形成统一融合的开源生态，避免出现割裂化、碎片化、政治化的全球开源生态。

**二是增加开源项目的投入和质量，提高中国开源影响力。** 鼓励企业和政府机构参与开源项目的投入，加大对开源组织的支持和赞助，提高开源项目的质量和数量，为国内外用户提供更好的开源产品和服务，让更多的用户使用中国主导的开源项目。

**三是推动开源产业化，实现开源组织的可持续发展。** 积极探索开源项目的商业模式和产业化路径，加强和产业的对接和合作，提供更好的技术支持和应用场景，推动开源技术在产业领域的应用和发展。

**四是加强针对国际领先开源组织的洞察能力，识别开源组织的发展趋势，为我国开源组织的发展提供借鉴。** 作为后来者，我国开源组织的发展必须积极跟踪业界最新的动态和经验，提高组织的战略规划能力，快速提高开源组织的治理能力、管理水平和战略意识，特别是对于开源与标准协同发展的业界趋势要认真研究，争取与国际领先开源组织齐头并进，不至于在战略上落后。

**五是加大开源普及力度，增强开源文化的认识和推广。** 加强开源理念的普及和推广，培养开源文化的意识和习惯，让更多人参与到开源项目的建设和推广中来。
